package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bAgrupaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bAgrupacionesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaAgrupacionesExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
	}

	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoAgrupaciones.xls";//NOPMD
		InputStream inputStream = W83bTablaAgrupacionesExcelAction.class.getResourceAsStream(strRutaExcel);//NOPMD 
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro//NOPMD 
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja 
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja//NOPMD 
        
        List listaAgrupaciones = (ArrayList)contexto.get("w83bListaAgrupaciones");//NOPMD 
        W83bAgrupacionesBean agrupacionBean = (W83bAgrupacionesBean)contexto.get("w83bAgrupacionesTempBean");//NOPMD
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb); 
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO); 
         
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);  
         
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)); 
        HashMap mapaAgrupaciones=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1 
        HSSFCell cell = row.createCell((short)3); 
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)2); 
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaAgrupaciones.get("tituloDepEs"); 
        StringBuffer tituloImagenEu =  (StringBuffer)mapaAgrupaciones.get("tituloDepEu");
        cell.setCellValue(tituloImagenEu.toString()); 
        
        cell = row.getCell((short)5); 
        cell.setCellValue(tituloImagenEs.toString()); 
        
        tituloImagenEs = (StringBuffer)mapaAgrupaciones.get("tituloDelelegacionEs");
        tituloImagenEu = (StringBuffer)mapaAgrupaciones.get("tituloDelelegacionEu");
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)2); 
        cell.setCellValue(tituloImagenEu.toString()); 
        
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEs.toString()); 
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.listadoAgrupaciones").toUpperCase());
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.codAgrupaciones"));
        cell = row.createCell(Short.parseShort("3")); 
        if(StringUtils.isEmpty(agrupacionBean.getCodAgrupaciones())){
        	cell.setCellValue("");
        }else{
        	cell.setCellValue(W83bUtilidades.numero(agrupacionBean.getCodAgrupaciones()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }
        
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.descAgrupacion"));
        cell = row.createCell(Short.parseShort("3"));
        if(StringUtils.isNotEmpty(agrupacionBean.getDescAgrupaciones())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("3"),W83bClsConstantes.TRECE,Short.parseShort("4")));//NOPMD
	        cell.setCellValue(agrupacionBean.getDescAgrupaciones().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
	    	cell = row.createCell(Short.parseShort("4")); 
	    	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("5"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
        cell = row.createCell(Short.parseShort("7")); 
        if(StringUtils.isEmpty(agrupacionBean.getBaja())||W83bClsConstantes.CONSTANTE_NO.equals(agrupacionBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase()); 	        	
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("5"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.descAgrupacionEusk"));
        cell = row.createCell(Short.parseShort("7"));
        if(StringUtils.isNotEmpty(agrupacionBean.getDescAgrupaciones())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("7"),W83bClsConstantes.TRECE,Short.parseShort("9")));//NOPMD
        	cell.setCellValue(agrupacionBean.getDescAgrupacionesEusk().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
    	if((agrupacionBean.getDescAgrupaciones()).length()>=(agrupacionBean.getDescAgrupacionesEusk()).length()){
	        if(38<agrupacionBean.getDescAgrupaciones().length()){
	    		row.setHeightInPoints((short)(18*((agrupacionBean.getDescAgrupaciones()).length()/38)+1));
	    	}
        }else{
        	if(37<agrupacionBean.getDescAgrupacionesEusk().length()){
         		row.setHeightInPoints((short)(18*((agrupacionBean.getDescAgrupacionesEusk()).length()/37)+1));
         	}
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("16")); // Creacin de la fila 1//NOPMD
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1//NOPMD
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.codAgrupaciones"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 1 para la fila 1//NOPMD
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.descAgrupacion"));
        
        cell = row.getCell(Short.parseShort("5")); // Creacin de la columna 1 para la fila 1//NOPMD
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.agrupaciones.descAgrupacionEusk"));
        
        for(int i=0;i<listaAgrupaciones.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+i); // Creacin de la fila 1//NOPMD
        	
        	//Cod Agrupacin
        	HSSFCell cell3 = row.createCell(Short.parseShort("1")); 
        	cell = row.createCell(Short.parseShort("0")); 
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("0"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("0")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getCodAgrupaciones())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getCodAgrupaciones()));
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));

        	cell3.setCellStyle(this.estiloFila(i,excel));
        	
        	//Descripcin Agrupacin
        	cell3 = row.createCell(Short.parseShort("4")); 
        	cell = row.createCell(Short.parseShort("1")); 
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("1"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("4")));//NOPMD 
        	if(StringUtils.isNotEmpty(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupaciones())){
        		cell.setCellValue(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupaciones());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4"));
        	cell.setCellStyle(this.estiloFila(i,excel));

        	cell3.setCellStyle(this.estiloFila(i,excel));
        	
        	//Descripcin Agrupacin Euskera
        	cell3 = row.createCell(Short.parseShort("4")); 
        	cell = row.createCell(Short.parseShort("5")); 
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("5"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("9"))); //NOPMD
        	
        	if(StringUtils.isNotEmpty(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupacionesEusk())){
        		cell.setCellValue(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupacionesEusk());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9"));
        	cell.setCellStyle(this.estiloFila(i,excel));

        	cell3.setCellStyle(this.estiloFila(i,excel));
        	
        	if(StringUtils.isNotEmpty(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupaciones()) 
        			&& StringUtils.isNotEmpty(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupacionesEusk())){
	        	if((((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupaciones()).length()>=(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupacionesEusk()).length()){
		        	if(75<(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupaciones()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupaciones()).length()/75)+1));
		        	}
		        }else{
		        	if(78<(((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupacionesEusk()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bAgrupacionesBean)listaAgrupaciones.get(i)).getDescAgrupacionesEusk()).length()/78)+1));
		        	}
		        }
        	}
        }
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoAgrupaciones.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
			
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;//NOPMD
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila numero.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
